/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e2, RSyntaxTextArea textArea, float x0) {
        return TokenUtils.getSubTokenList(tokenList, pos, e2, textArea, x0, null);
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e2, RSyntaxTextArea textArea, float x0, TokenImpl tempToken) {
        Token t2;
        if (tempToken == null) {
            tempToken = new TokenImpl();
        }
        for (t2 = tokenList; t2 != null && t2.isPaintable() && !t2.containsPosition(pos); t2 = t2.getNextToken()) {
            x0 += t2.getWidth(textArea, e2, x0);
        }
        if (t2 != null && t2.isPaintable()) {
            if (t2.getOffset() != pos) {
                int difference = pos - t2.getOffset();
                x0 += t2.getWidthUpTo(t2.length() - difference + 1, textArea, e2, x0);
                tempToken.copyFrom(t2);
                tempToken.makeStartAt(pos);
                return new TokenSubList(tempToken, x0);
            }
            return new TokenSubList(t2, x0);
        }
        return new TokenSubList(tokenList, x0);
    }

    public static int getWhiteSpaceTokenLength(Token t2, int tabSize, int curOffs) {
        int length = 0;
        for (int i2 = 0; i2 < t2.length(); ++i2) {
            char ch2 = t2.charAt(i2);
            if (ch2 == '\t') {
                int newCurOffs = (curOffs + tabSize) / tabSize * tabSize;
                length += newCurOffs - curOffs;
                curOffs = newCurOffs;
                continue;
            }
            ++length;
            ++curOffs;
        }
        return length;
    }

    public static boolean isBlankOrAllWhiteSpace(Token t2) {
        while (t2 != null && t2.isPaintable()) {
            if (!t2.isCommentOrWhitespace()) {
                return false;
            }
            t2 = t2.getNextToken();
        }
        return true;
    }

    public static boolean isBlankOrAllWhiteSpaceWithoutComments(Token t2) {
        while (t2 != null && t2.isPaintable()) {
            if (!t2.isWhitespace()) {
                return false;
            }
            t2 = t2.getNextToken();
        }
        return true;
    }

    public static String tokenToHtml(RSyntaxTextArea textArea, Token token) {
        StringBuilder style = new StringBuilder();
        Font font = textArea.getFontForTokenType(token.getType());
        if (font.isBold()) {
            style.append("font-weight: bold;");
        }
        if (font.isItalic()) {
            style.append("font-style: italic;");
        }
        Color c2 = textArea.getForegroundForToken(token);
        style.append("color: ").append(HtmlUtil.getHexString(c2)).append(";");
        return "<span style=\"" + style + "\">" + HtmlUtil.escapeForHtml(token.getLexeme(), "\n", true) + "</span>";
    }

    public static class TokenSubList {
        public Token tokenList;
        public float x;

        public TokenSubList(Token tokenList, float x2) {
            this.tokenList = tokenList;
            this.x = x2;
        }
    }
}

